/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.model.InputNamesIfc;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class InputNamesPanel
extends DataInputPanel {
    protected InputNamesIfc inputNamesIfc;
    protected JLabel lblInputsHeader;
    public JLabel lblOutputsHeader;
    protected Vector inputTextFields;
    protected Vector outputTextFields;
    protected String[] inputNames;
    protected String[] outputNames;
    private JButton importButton = null;
    private JButton exportButton = null;
    private String fFileName;
    private static final String CHARSET_CSV = "UTF-8";
    private static final byte[] CHARSET_HEAD = new byte[]{-17, -69, -65};

    public InputNamesPanel(InputNamesIfc inputNamesIfc) {
        this.inputNamesIfc = inputNamesIfc;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = null;
        this.lblInputsHeader = new JLabel("Inputs");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.lblInputsHeader, gbc);
        JPanel pInputNames = new JPanel(new GridBagLayout());
        JScrollPane spInputNames = new JScrollPane(pInputNames);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)spInputNames, gbc);
        this.inputNames = inputNamesIfc.getInputNames();
        Vector<JLabel> inputLabels = new Vector<JLabel>(this.inputNames.length);
        this.inputTextFields = new Vector(this.inputNames.length);
        int i = 0;
        while (i < this.inputNames.length) {
            JLabel label = new JLabel(this.inputNames[i]);
            gbc.gridx = 0;
            gbc.gridy = i;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.insets = new Insets(2, 5, 2, 5);
            inputLabels.add(label);
            pInputNames.add((Component)label, gbc);
            JTextField textField = new JTextField();
            gbc.gridx = 1;
            gbc.gridy = i++;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 0, 0, 3);
            this.inputTextFields.addElement(textField);
            pInputNames.add((Component)textField, gbc);
        }
        gbc.gridx = 0;
        gbc.gridy = 100;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        pInputNames.add((Component)new JPanel(), gbc);
        this.lblOutputsHeader = new JLabel("Outputs");
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.lblOutputsHeader, gbc);
        JPanel pOutputNames = new JPanel(new GridBagLayout());
        JScrollPane spOutputNames = new JScrollPane(pOutputNames);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)spOutputNames, gbc);
        this.outputNames = inputNamesIfc.getOutputNames();
        Vector<JLabel> outputLabels = new Vector<JLabel>(this.outputNames.length);
        this.outputTextFields = new Vector(this.outputNames.length);
        int i2 = 0;
        while (i2 < this.outputNames.length) {
            JLabel label = new JLabel(this.outputNames[i2]);
            gbc.gridx = 0;
            gbc.gridy = i2;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.insets = new Insets(2, 5, 2, 5);
            outputLabels.add(label);
            pOutputNames.add((Component)label, gbc);
            JTextField textField = new JTextField();
            gbc.gridx = 1;
            gbc.gridy = i2++;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 0, 0, 3);
            this.outputTextFields.add(textField);
            pOutputNames.add((Component)textField, gbc);
        }
        gbc.gridx = 0;
        gbc.gridy = 100;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        pOutputNames.add((Component)new JPanel(), gbc);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.importButton = new JButton(Language.getString("dialog.comments.importButton", "Import"));
        this.importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File file = Application.getInstance().chooseCSVFile(InputNamesPanel.this, InputNamesPanel.this.fFileName, 0);
                if (file != null) {
                    InputNamesPanel.this.importFromCSV(file);
                }
            }
        });
        this.exportButton = new JButton(Language.getString("dialog.comments.exportButton", "Export"));
        this.exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File file = Application.getInstance().chooseCSVFile(InputNamesPanel.this, InputNamesPanel.this.fFileName, 1);
                if (file != null) {
                    InputNamesPanel.this.exportToCSV(file);
                }
            }
        });
        buttonPanel.add(this.importButton);
        buttonPanel.add(this.exportButton);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)buttonPanel, gbc);
    }

    private void importFromCSV(File file) {
        try {
            FileInputStream is = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, CHARSET_CSV));
            Hashtable<String, String> names = new Hashtable<String, String>();
            String line = br.readLine();
            if (line.contains("Connector,name")) {
                int i;
                while ((line = br.readLine()) != null) {
                    String[] items = line.split(",");
                    if (items == null || items.length != 2) continue;
                    names.put(items[0], items[1]);
                }
                for (i = 0; i < this.inputNames.length; ++i) {
                    if (names.containsKey(this.inputNames[i])) {
                        ((JTextField)this.inputTextFields.elementAt(i)).setText((String)names.get(this.inputNames[i]));
                        continue;
                    }
                    ((JTextField)this.inputTextFields.elementAt(i)).setText("");
                }
                for (i = 0; i < this.outputNames.length; ++i) {
                    if (names.containsKey(this.outputNames[i])) {
                        ((JTextField)this.outputTextFields.elementAt(i)).setText((String)names.get(this.outputNames[i]));
                        continue;
                    }
                    ((JTextField)this.outputTextFields.elementAt(i)).setText("");
                }
            }
            ((InputStream)is).close();
            br.close();
            Log.println(Language.getString("msg.readSuccessful", "Read successful"));
        }
        catch (Exception e1) {
            Log.println(Language.getString("error.openFile", "Reading % failed", file));
        }
    }

    private void exportToCSV(File file) {
        try {
            String content;
            int i;
            FileOutputStream os = new FileOutputStream(file);
            OutputStreamWriter fFileWriter = new OutputStreamWriter((OutputStream)os, CHARSET_CSV);
            ((OutputStream)os).write(CHARSET_HEAD);
            StringBuffer strBuffer = new StringBuffer("Connector,name");
            for (i = 0; i < this.inputNames.length; ++i) {
                content = ((JTextField)this.inputTextFields.elementAt(i)).getText();
                strBuffer.append("\n");
                strBuffer.append(this.inputNames[i]);
                strBuffer.append(",");
                strBuffer.append(content);
            }
            for (i = 0; i < this.outputNames.length; ++i) {
                content = ((JTextField)this.outputTextFields.elementAt(i)).getText();
                strBuffer.append("\n");
                strBuffer.append(this.outputNames[i]);
                strBuffer.append(",");
                strBuffer.append(content);
            }
            fFileWriter.write(strBuffer.toString());
            fFileWriter.flush();
            fFileWriter.close();
            ((OutputStream)os).close();
            Log.println(Language.getString("msg.writeSuccessful", "Writing successful"));
        }
        catch (IOException ex) {
            Log.println(Language.getString("error.saveFile", "Error saving file: " + file, file));
        }
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.width = Math.max(400, preferredSize.width);
        preferredSize.height -= 80;
        return preferredSize;
    }

    public String getTitle() {
        return Language.getString("dialog.comments.title", "Comments");
    }

    public void loadFieldContents() {
        String content;
        int i;
        for (i = 0; i < this.inputNames.length; ++i) {
            content = this.inputNamesIfc.getInputName(this.inputNames[i]);
            ((JTextField)this.inputTextFields.elementAt(i)).setText(content);
        }
        for (i = 0; i < this.outputNames.length; ++i) {
            content = this.inputNamesIfc.getInputName(this.outputNames[i]);
            ((JTextField)this.outputTextFields.elementAt(i)).setText(content);
        }
        this.fFileName = LogoProperties.instance().getProperty("IONameFile");
    }

    public void setLabels() {
        this.lblInputsHeader.setText(Language.getString("dialog.comments.inputCommentsPanel.label", "Inputs"));
        this.lblOutputsHeader.setText(Language.getString("dialog.comments.outputCommentsPanel.label", "Outputs"));
    }

    public void storeFieldContents() {
        String content;
        int i;
        for (i = 0; i < this.inputNames.length; ++i) {
            content = ((JTextField)this.inputTextFields.elementAt(i)).getText();
            this.inputNamesIfc.setInputName(this.inputNames[i], content);
        }
        for (i = 0; i < this.outputNames.length; ++i) {
            content = ((JTextField)this.outputTextFields.elementAt(i)).getText();
            this.inputNamesIfc.setInputName(this.outputNames[i], content);
        }
        LogoDrawing drawing = this.inputNamesIfc.getDrawing();
        drawing.updateInputNames();
        drawing.forceUpdate();
        drawing.setModified(true);
        if (this.fFileName != null && this.fFileName.length() > 0) {
            LogoProperties.instance().setProperty("IONameFile", this.fFileName);
            LogoProperties.instance().saveProperties();
        }
    }

    public boolean checkChanged() {
        String modelContent;
        String guiContent;
        int i;
        for (i = 0; i < this.inputNames.length; ++i) {
            guiContent = ((JTextField)this.inputTextFields.elementAt(i)).getText();
            if (guiContent.equals(modelContent = this.inputNamesIfc.getInputName(this.inputNames[i]))) continue;
            return true;
        }
        for (i = 0; i < this.outputNames.length; ++i) {
            guiContent = ((JTextField)this.outputTextFields.elementAt(i)).getText();
            if (guiContent.equals(modelContent = this.inputNamesIfc.getInputName(this.outputNames[i]))) continue;
            return true;
        }
        return false;
    }
}

